local t = Def.ActorFrame {};

local function tablelength(T)
  local count = 0
  for _ in pairs(T) do count = count + 1 end
  return count
end

Songs = SONGMAN:GetAllSongs();
Results = {};
currentResult = 1;

local function showResult(self, index)
	song = Results[index];
	
	local topScreen = SCREENMAN:GetTopScreen();
	local screenName = topScreen:GetName();
	if screenName == "ScreenNetSelectMusic" then
		local MusicWheel = topScreen:GetChild("MusicWheel");
		if MusicWheel ~= nil then
			MusicWheel:SelectSong(song);
			MusicWheel:Move(1); -- lazy fix to trigger CurrentSongChanged
			MusicWheel:Move(-1); -- lazy fix to trigger CurrentSongChanged
			MusicWheel:Move(0); -- lazy fix to trigger CurrentSongChanged
		end;
	end;
	
end;

local function searchSong(self ,searchString)
	if string.len(searchString) < 3 then
		return;
	end;
	
	searchString = string.lower(searchString);
	Results = {};
	text = "";
	n = 0;
	for k,v in pairs(Songs) do
		title = string.lower(v:GetDisplayFullTitle());
		if string.find(title,searchString) ~= nil and
		v:GetStepsSeconds() > 0.0 then
			text = text .. title .. "\n";
			n = n + 1;
			
			key = {song = v, i=n}
			table.insert(Results, n, v);
		end;
	end;
	
	local c = self:GetChildren();

	if tablelength(Results) > 0 then
		if tablelength(Results) == 1 then
			c.textfield2:settext(tablelength(Results) .. " Results found for \""..searchString.."\"");
		else
			c.textfield2:settext(tablelength(Results) .. " Results found for \""..searchString.."\"");
		end;
		
		currentResult = 1;
		showResult(self, currentResult);
	else
		c.textfield2:settext("No results were found.");
	end;
end;

local EnterSongName

local function EnterNameSong(event)
	if event.type == "InputEventType_Release" then return false end
	if event.DeviceInput.button == "DeviceButton_1" then
		EnterSongName:playcommand("SongName")
	elseif event.DeviceInput.button == "DeviceButton_2" then
		EnterSongName:playcommand("SearchSong")
	elseif event.DeviceInput.button == "DeviceButton_3" then
		EnterSongName:playcommand("SearchPrevSong")
	elseif event.DeviceInput.button == "DeviceButton_4" then
		EnterSongName:playcommand("SearchNextSong")
	end
end

t[#t+1] = Def.ActorFrame{
	Name="SearchBar";
	InitCommand=function(self)
		EnterSongName=self
		self:xy(CenterX(),Bottom())
	end,
	OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(EnterNameSong) end,
	
	SM_SearchMessageCommand = function(self,params)
		local c = self:GetChildren();
		c.textfield:settext(params.searchString);
	end;
	
	SongNameCommand = function(self, params)
		local c = self:GetChildren();
		c.textfield:settext("");
		local topScreen = SCREENMAN:GetTopScreen();
		local screenName = topScreen:GetName();
		if screenName == "ScreenNetSelectMusic" then
			SCREENMAN:AddNewScreenToTop("ScreenTextEntry");
			local searchSettings = {
				Question = "Enters Song Name:\n(Min Number of Characters: 3)",
				MaxInputLength = 255,
				OnOK = function(answer)
					MESSAGEMAN:Broadcast("SM_Search",{searchString = answer});
				end,
			};
			SCREENMAN:GetTopScreen():Load(searchSettings);
		end;
		return true;
	end;
	
	SearchSongCommand = function(self, params)
		local c = self:GetChildren();
		local searchString = c.textfield:GetText();
		if searchString ~= "Presiona para buscar..." then
			searchSong(self, searchString);
		end;
		return true;
	end;
	
	SearchPrevSongCommand = function(self, params)
		local c = self:GetChildren();
		if currentResult > 1 and currentResult <= tablelength(Results) then
			currentResult = currentResult - 1;
			showResult(self, currentResult);
		end;
		return true;
	end;
	
	SearchNextSongCommand = function(self, params)
		local c = self:GetChildren();
		if currentResult >= 1 and currentResult < tablelength(Results) then
			currentResult = currentResult + 1;
			showResult(self, currentResult);
		end;
		return true;
	end;
	
	LoadFont("Common normal") .. {
		InitCommand=cmd(x,-212;y,-32;zoom,0.4;valign,0;maxwidth,340);
		Text=string.upper("Press 3 for Prev Song");
	};
	
	LoadFont("Common normal") .. {
		InitCommand=cmd(x,212;y,-32;zoom,0.4;valign,0;maxwidth,340);
		Text=string.upper("Press 4 for Next Song");
	};
	
	LoadFont("Common normal") .. {
		Name="textfield";
		InitCommand=cmd(y,-32;zoom,0.4;valign,0;maxwidth,640);
		Text=string.upper("Press 1 to Enter Song name.");
	};
	
	LoadFont("Common normal") .. {
		Name="textfield2";
		InitCommand=cmd(y,-12;zoom,0.4;valign,0);
		Text=string.upper("Press 2 to Search Songs.");
	};
	
	BeginCommand=function(self)
		self:SetUpdateFunction( UpdateSearchBar );
		self:SetUpdateRate( 1/30 );
	end;
};

return t